﻿using System;
using System.Web;
using System.Web.Services;
using System.Web.Services.Protocols;
using System.ComponentModel;
using System.Web.SessionState;


public static class SessionFacade
{
    /// <summary>
    ///     SessionFacade provides a facade to the ASP.NET Session object.
    ///     All access to Session variables must be through this class.
    ///     Code example used from http://www.codeproject.com/KB/aspnet/session_facade.aspx
    /// </summary>
   
    # region Private Constants
    //---------------------------------------------------------------------
    private const string menuItemSelected = "MenuItemSelected";
    private const string referenceStatus = "ReferenceStatus";
    //---------------------------------------------------------------------
    # endregion

    # region Public Properties
    //---------------------------------------------------------------------
    
    /// <summary>
    ///     MenuItemSelected is a string value of the last menu item selected by the user.
    /// </summary>
    public static string MenuItemSelected
    {
        get
        {
            return HttpContext.Current.Session[menuItemSelected].ToString();
        }

        set
        {
            HttpContext.Current.Session[menuItemSelected] = value;
        }
    }

    /// <summary>
    ///     referenceStatus is an integer value of the last refernce status selected by the user.
    /// </summary>
    public static int ReferenceStatus
    {
        
        get
        {
            try
            {
                return Convert.ToInt32(HttpContext.Current.Session[menuItemSelected]);
            }
            catch
            {
                return 0;
            }
            
        }

        set
        {
            int _tempInt;

            try
            {
                _tempInt = Convert.ToInt32(value);
            }
            catch
            {
                _tempInt = 0;
            }

            HttpContext.Current.Session[menuItemSelected] = _tempInt;
        }
    }
    //---------------------------------------------------------------------
    # endregion

}
